const QUEST_ESCORT=1;const QUEST_TRADE=2;const QUEST_BOUNTY=3;const QUEST_OTHER=4;const HATES_COMBAT=1;const HATES_OTHERS=2;const HATES_MINING=3;const HATES_PLANET=4;function Quest(name,type){this.name=name;this.type=type;this.reward=0;this.cap=0;this.escorts=1;this.planet="";this.system="";this.shipname="";this.days=0;this.hatesPlanet="";this.escortCondition=null;this.condition=false;this.finished=false;}
function HasQuestFailed(quest){if(quest.days<0)return true;if(quest.type==QUEST_ESCORT){return quest.condition;}}
function DrawQuestDesc(quest,x,y,w,h){var desc="";if(HasQuestFailed(quest)){if(quest.type==QUEST_ESCORT){desc="Sorry, but I'm disappointed of your service. I'll pay only half as much.\n";desc+="\nEscorts: "+quest.escorts;}
if(quest.type==QUEST_TRADE){desc="Dang, the time ran out, I won't get an on time bonus anymore.\n";desc+="\nCargo: "+quest.cap;}
desc+="\nDays: out of time";if(quest.type==QUEST_ESCORT)desc+="\nReward: "+quest.reward/2;if(quest.type==QUEST_TRADE)desc+="\nReward: "+quest.reward+" (no bonus)";}
else{desc=quest.desc+"\n";if(quest.type==QUEST_TRADE)desc+="\nCargo: "+quest.cap;if(quest.type==QUEST_ESCORT)desc+="\nEscorts: "+quest.escorts;desc+="\nDays: "+quest.days;desc+="\nReward: "+quest.reward;}
if(quest.type==QUEST_BOUNTY)desc+="\nLocation: "+quest.system+" System";else desc+="\nLocation: "+quest.planet+", "+quest.system+" System";System.windowFont.drawTextBox(x,y,w,h,0,desc);}
function GenerateQuest(){var chance=Utility.random(100);if(chance>90)return GenerateBountyQuest();else if(chance>55)return GenerateTradeQuest();else return GenerateEscortQuest();}
function GenerateTradeQuest()
{var quest=new Quest("Trade: ",QUEST_TRADE);quest.desc="We need someone to trade ";var subtype=Utility.random(100);if(subtype>80){quest.name+="Elite ";quest.cap+=45;quest.desc+="elite ";}
else if(subtype>50){quest.name+="Colonial ";quest.cap+=20;quest.desc+="colonial ";}
else{quest.name+="Basic ";quest.desc+="basic ";}
subtype=Utility.random(100);if(subtype>80){quest.name+="Exotics";quest.cap+=25;quest.desc+="exotics ";}
else if(subtype>50){quest.name+="Supplies";quest.cap+=15;quest.desc+="supplies ";}
else{quest.name+="Goods";quest.cap+=5;quest.desc+="goods ";}
quest.cap+=Utility.random(10);quest.reward=25*quest.cap;quest.reward+=Utility.random(50);var loc=StarChart.getRandomPlanet();quest.planet=loc.planet;quest.system=loc.system;quest.desc+="to "+quest.planet+" in the "+loc.system+" system.";quest.days=10+Utility.random(10);subtype=Utility.random(100);if(subtype>75){quest.days=Math.floor(quest.days/2);quest.desc="Rush Delivery! "+quest.desc;quest.reward*=2;}
quest.finished=true;return quest;}
function GenerateEscortQuest()
{var quest=new Quest("Escort: ",QUEST_ESCORT);quest.desc="Hello there, I'm an ";var type=Utility.random(2);var subtype=0;switch(type){case 0:quest.name+="Important Person";quest.reward+=300;quest.days=3;quest.desc+="important person on the behalf of ";subtype=Utility.random(4);switch(subtype){case 0:quest.desc+="the traders union ";break;case 1:quest.desc+="the workers union ";break;case 2:quest.desc+="the peace keepers ";break;case 3:quest.desc+="the government ";break;case 4:quest.desc+="the military ";break;}
break;case 1:quest.name+="Official Person";quest.reward+=200;quest.days=5;quest.desc+="official within ";subtype=Utility.random(2);if(subtype==0)quest.desc+="the military and I'm ";if(subtype==1)quest.desc+="the government and I'm ";if(subtype==2)quest.desc+="a large corporation and I'm ";break;case 2:quest.name+="Average Person";quest.reward+=100;quest.days=7;quest.desc+="average person ";break;}
quest.desc+="looking to ";subtype=Utility.random(10);switch(subtype){case 0:quest.desc+="make peace with the people of ";break;case 1:quest.desc+="make trade with the people of ";break;case 2:quest.desc+="marry my fiancee at ";break;case 3:quest.desc+="make a life at ";break;case 4:quest.desc+="make a name for myself at ";break;case 5:quest.desc+="make it big at ";break;case 6:quest.desc+="return home to ";break;case 7:quest.desc+="take sweet revenge on somebody at ";break;case 8:quest.desc+="move permanently to ";break;case 9:quest.desc+="collect a loan at ";break;case 10:quest.desc+="go shopping at ";break;}
var loc=StarChart.getRandomPlanet();quest.planet=loc.planet;quest.system=loc.system;quest.desc+=quest.planet+" in the "+loc.system+" system.";subtype=Utility.random(100);if(subtype>=50){quest.desc+=" Also, I dislike ";subtype=Utility.random(3);if(subtype==0){quest.escortCondition=HATES_MINING;quest.desc+="asteroid mining, it's too boring so don't mine anything.";}
if(subtype==1){quest.reward+=200;quest.escortCondition=HATES_COMBAT;quest.desc+="combat, it scares the heck out of me!";}
if(subtype==2){quest.reward+=100;quest.escortCondition=HATES_OTHERS;quest.desc+="other people, I want to be kept alone.";}
if(subtype==3){var p=StarChart.getRandomPlanet().planet;while(p==quest.planet)p=StarChart.getRandomPlanet().planet;quest.hatesPlanet=p;quest.desc+=" the planet "+quest.hatesPlanet+", because of some bad run-ins.";}}
quest.finished=true;return quest;}
function GenerateBountyQuest()
{var quest=new Quest("Bounty: Kill ",QUEST_BOUNTY);quest.desc="We need someone to declare swift justice on the ";var type=Utility.random(6),typestr="";switch(type){case 0:typestr="Bandit";break;case 1:typestr="Renegade";break;case 2:typestr="Criminal";break;case 3:typestr="Pirate";break;case 4:typestr="Maruader";break;case 5:typestr="Brigand";break;case 6:typestr="Outlaw";break;}
quest.name+=typestr;quest.desc+=typestr.toLowerCase();quest.shipname=GenerateName(NAME_BOUNTY);quest.desc+=" by the name of: "+quest.shipname+". ";quest.days=30;quest.reward=100+Utility.random(1500);var loc=StarChart.getRandomPlanet();quest.planet=loc.planet;quest.system=loc.system;quest.desc+="His last known location was in the "+quest.system+" system.";return quest;}